<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreTabellaPrezzi extends VisualizzatoreComponente {
        private $classeTabelle;
        
        function __construct($db) {
            parent::__construct($db);
            $this->classeTabelle = "";
        }

        function generaContenutoSezione($dati) {
            $sezione = parent::getDb()->leggiSingolaRiga("geec_tabellePrezzi",$dati["idElemento"]);
            echo"<div class=\"{$sezione["spazioOccupato"]}\">\n"
                    . "<div class=\"tabella-prezzi\">\n"
                    . "<div class=\"row d-flex justify-content-center\">\n";
                $queryTabellePrezzi = "SELECT * FROM geec_colonneTabellaPrezzi WHERE idTabella={$sezione["id"]} ORDER BY posizione ASC";
                $risTabelle = parent::getDb()->eseguiQueryLettura($queryTabellePrezzi);
                $this->impostaClasseTabella($risTabelle->num_rows);
                while($colonna = $risTabelle->fetch_assoc()) {
                    $this->stampaColonna($colonna);
                }
                echo"</div>"
                . "</div>"
            . "</div>";
        }
        
        function stampaColonna($colonna) {
            if($colonna["preferita"]=="si") {
               $classeAggiuntiva = "popular";
            }
            else {
               $classeAggiuntiva = "";
            }
            echo"<div class=\"$this->classeTabelle\">\n"
                    . "<div class=\"card text-center $classeAggiuntiva border full-width\">\n";
                if($colonna["immagine"]!="") {
                    echo"<img class=\"img-fluid\" src=\"{$colonna["immagine"]}\">";
                }
                if($colonna["prezzo"]>0) {
                    echo"<div class=\"card-header\">";
                        if($colonna["prezzoScontato"]>0) {
                            echo"<h4 class=\"text-muted display-4 mb-0\">{$colonna["prezzoScontato"]} {$colonna["valuta"]}</h4>";
                        }
                        $stringaSuffisso = ($colonna["suffisso"]!="") ? " / {$colonna["suffisso"]}" : "";
                        echo"<h3 class=\"display-2\"><span class=\"currency\">{$colonna["valuta"]}</span>{$colonna["prezzo"]}<span class=\"period\">$stringaSuffisso</span></h3>
                    </div>";
                }
                echo "<div class=\"card-block\">";
                echo"<h4 class=\"card-title text-primary\">{$colonna["nome"]}</h4>";
                echo"<p class=\"text-left m-4\"> {$colonna["descrizione"]}</p>";
                echo"<ul class=\"list-group\">";
                $queryElementiTabella = "SELECT * FROM geec_elementiTabellaPrezzi WHERE idColonna={$colonna["id"]} ORDER BY posizione ASC";
                $risElementi = parent::getDb()->eseguiQueryLettura($queryElementiTabella);
                while($elemento = $risElementi->fetch_assoc()) {
                    $this->stampaElementoTabella($elemento);
                }
                echo"</ul>";
                if($colonna["link"]!="") {
                    echo"<a class=\"btn btn-primary leggi-tutto\" href=\"javascript:void\" onclick=gestisciClick({$colonna["id"]},'{$colonna["link"]}','incrementaClickColonnaTabellaPrezzi')> {$colonna["etichettaLink"]} </a>";
                }
                echo"</div>\n";
                echo"</div>\n";
                echo"</div>\n";
        }

        function stampaElementoTabella($elemento) {
            if($elemento["icona"]!="") {
                echo"<li class=\"list-group-item {$elemento["classeElemento"]}\"> <i class=\"{$elemento["icona"]}\"></i>{$elemento["nome"]}</li>";
            }
            else {
                echo"<li class=\"list-group-item {$elemento["classeElemento"]}\">{$elemento["nome"]}</li>";
            }
        }
        
        /*
         * questa funzione imposta la classe css che devono avere le tabelle prezzi
         * a seconda del numero di elementi trovati possono avere varlore col-sm-6,
         * col-sm-4 o col-sm-3
         */
        function impostaClasseTabella($numeroElementi) {
            switch ($numeroElementi) {
                case 1:
                    $this->classeTabelle = "col-12 col-md-6 d-flex";
                    break;
                case 2:
                    $this->classeTabelle = "col-12 col-lg-4 d-flex";
                    break;
                case 3:
                    $this->classeTabelle = "col-12 col-lg-4 d-flex";
                    break;
                case 4:
                    $this->classeTabelle = "col-12 col-lg-3 d-flex";
                    break;
                default :
                    $this->classeTabelle = "col-12 col-sm-3 d-flex";
                    break;
            }
        }
    }
